package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UserSettings(
    telephony: zio.aws.chime.model.TelephonySettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UserSettings = {
    import UserSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UserSettings
      .builder()
      .telephony(telephony.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UserSettings.ReadOnly =
    zio.aws.chime.model.UserSettings.wrap(buildAwsValue())
}
object UserSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UserSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UserSettings =
      zio.aws.chime.model.UserSettings(telephony.asEditable)
    def telephony: zio.aws.chime.model.TelephonySettings.ReadOnly
    def getTelephony
        : ZIO[Any, Nothing, zio.aws.chime.model.TelephonySettings.ReadOnly] =
      ZIO.succeed(telephony)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UserSettings
  ) extends zio.aws.chime.model.UserSettings.ReadOnly {
    override val telephony: zio.aws.chime.model.TelephonySettings.ReadOnly =
      zio.aws.chime.model.TelephonySettings.wrap(impl.telephony())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UserSettings
  ): zio.aws.chime.model.UserSettings.ReadOnly = new Wrapper(impl)
}
