package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait UserType {
  def unwrap: software.amazon.awssdk.services.chime.model.UserType
}
object UserType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.UserType
  ): zio.aws.chime.model.UserType = value match {
    case software.amazon.awssdk.services.chime.model.UserType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.UserType.PRIVATE_USER =>
      val r = PrivateUser
      r
    case software.amazon.awssdk.services.chime.model.UserType.SHARED_DEVICE =>
      val r = SharedDevice
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.UserType {
    override def unwrap: software.amazon.awssdk.services.chime.model.UserType =
      software.amazon.awssdk.services.chime.model.UserType.UNKNOWN_TO_SDK_VERSION
  }
  case object PrivateUser extends zio.aws.chime.model.UserType {
    override def unwrap: software.amazon.awssdk.services.chime.model.UserType =
      software.amazon.awssdk.services.chime.model.UserType.PRIVATE_USER
  }
  case object SharedDevice extends zio.aws.chime.model.UserType {
    override def unwrap: software.amazon.awssdk.services.chime.model.UserType =
      software.amazon.awssdk.services.chime.model.UserType.SHARED_DEVICE
  }
}
