package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VideoArtifactsConfiguration(
    state: zio.aws.chime.model.ArtifactsState,
    muxType: Optional[zio.aws.chime.model.VideoMuxType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.VideoArtifactsConfiguration = {
    import VideoArtifactsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.VideoArtifactsConfiguration
      .builder()
      .state(state.unwrap)
      .optionallyWith(muxType.map(value => value.unwrap))(_.muxType)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.VideoArtifactsConfiguration.ReadOnly =
    zio.aws.chime.model.VideoArtifactsConfiguration.wrap(buildAwsValue())
}
object VideoArtifactsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.VideoArtifactsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.VideoArtifactsConfiguration =
      zio.aws.chime.model
        .VideoArtifactsConfiguration(state, muxType.map(value => value))
    def state: zio.aws.chime.model.ArtifactsState
    def muxType: Optional[zio.aws.chime.model.VideoMuxType]
    def getState: ZIO[Any, Nothing, zio.aws.chime.model.ArtifactsState] =
      ZIO.succeed(state)
    def getMuxType: ZIO[Any, AwsError, zio.aws.chime.model.VideoMuxType] =
      AwsError.unwrapOptionField("muxType", muxType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.VideoArtifactsConfiguration
  ) extends zio.aws.chime.model.VideoArtifactsConfiguration.ReadOnly {
    override val state: zio.aws.chime.model.ArtifactsState =
      zio.aws.chime.model.ArtifactsState.wrap(impl.state())
    override val muxType: Optional[zio.aws.chime.model.VideoMuxType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.muxType())
        .map(value => zio.aws.chime.model.VideoMuxType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.VideoArtifactsConfiguration
  ): zio.aws.chime.model.VideoArtifactsConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
