package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait VideoMuxType {
  def unwrap: software.amazon.awssdk.services.chime.model.VideoMuxType
}
object VideoMuxType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.VideoMuxType
  ): zio.aws.chime.model.VideoMuxType = value match {
    case software.amazon.awssdk.services.chime.model.VideoMuxType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.VideoMuxType.VIDEO_ONLY =>
      val r = VideoOnly
      r
  }
  case object unknownToSdkVersion extends zio.aws.chime.model.VideoMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.VideoMuxType =
      software.amazon.awssdk.services.chime.model.VideoMuxType.UNKNOWN_TO_SDK_VERSION
  }
  case object VideoOnly extends zio.aws.chime.model.VideoMuxType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.VideoMuxType =
      software.amazon.awssdk.services.chime.model.VideoMuxType.VIDEO_ONLY
  }
}
