package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait VoiceConnectorAwsRegion {
  def unwrap
      : software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion
}
object VoiceConnectorAwsRegion {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion
  ): zio.aws.chime.model.VoiceConnectorAwsRegion = value match {
    case software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion.US_EAST_1 =>
      val r = `us-east-1`
      r
    case software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion.US_WEST_2 =>
      val r = `us-west-2`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.VoiceConnectorAwsRegion {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion =
      software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion.UNKNOWN_TO_SDK_VERSION
  }
  case object `us-east-1` extends zio.aws.chime.model.VoiceConnectorAwsRegion {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion =
      software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion.US_EAST_1
  }
  case object `us-west-2` extends zio.aws.chime.model.VoiceConnectorAwsRegion {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion =
      software.amazon.awssdk.services.chime.model.VoiceConnectorAwsRegion.US_WEST_2
  }
}
