package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  Iso8601Timestamp,
  VoiceConnectorGroupName,
  NonEmptyString
}
import scala.jdk.CollectionConverters._
final case class VoiceConnectorGroup(
    voiceConnectorGroupId: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[VoiceConnectorGroupName] = Optional.Absent,
    voiceConnectorItems: Optional[
      Iterable[zio.aws.chime.model.VoiceConnectorItem]
    ] = Optional.Absent,
    createdTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    updatedTimestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    voiceConnectorGroupArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.VoiceConnectorGroup = {
    import VoiceConnectorGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.VoiceConnectorGroup
      .builder()
      .optionallyWith(
        voiceConnectorGroupId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.voiceConnectorGroupId)
      .optionallyWith(
        name.map(value =>
          VoiceConnectorGroupName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        voiceConnectorItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.voiceConnectorItems)
      .optionallyWith(
        createdTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        updatedTimestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.updatedTimestamp)
      .optionallyWith(
        voiceConnectorGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.voiceConnectorGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.VoiceConnectorGroup.ReadOnly =
    zio.aws.chime.model.VoiceConnectorGroup.wrap(buildAwsValue())
}
object VoiceConnectorGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.VoiceConnectorGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.VoiceConnectorGroup =
      zio.aws.chime.model.VoiceConnectorGroup(
        voiceConnectorGroupId.map(value => value),
        name.map(value => value),
        voiceConnectorItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdTimestamp.map(value => value),
        updatedTimestamp.map(value => value),
        voiceConnectorGroupArn.map(value => value)
      )
    def voiceConnectorGroupId: Optional[NonEmptyString]
    def name: Optional[VoiceConnectorGroupName]
    def voiceConnectorItems
        : Optional[List[zio.aws.chime.model.VoiceConnectorItem.ReadOnly]]
    def createdTimestamp: Optional[Iso8601Timestamp]
    def updatedTimestamp: Optional[Iso8601Timestamp]
    def voiceConnectorGroupArn: Optional[NonEmptyString]
    def getVoiceConnectorGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("voiceConnectorGroupId", voiceConnectorGroupId)
    def getName: ZIO[Any, AwsError, VoiceConnectorGroupName] =
      AwsError.unwrapOptionField("name", name)
    def getVoiceConnectorItems: ZIO[Any, AwsError, List[
      zio.aws.chime.model.VoiceConnectorItem.ReadOnly
    ]] = AwsError.unwrapOptionField("voiceConnectorItems", voiceConnectorItems)
    def getCreatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getUpdatedTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("updatedTimestamp", updatedTimestamp)
    def getVoiceConnectorGroupArn: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("voiceConnectorGroupArn", voiceConnectorGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.VoiceConnectorGroup
  ) extends zio.aws.chime.model.VoiceConnectorGroup.ReadOnly {
    override val voiceConnectorGroupId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorGroupId())
        .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val name: Optional[VoiceConnectorGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chime.model.primitives.VoiceConnectorGroupName(value)
      )
    override val voiceConnectorItems
        : Optional[List[zio.aws.chime.model.VoiceConnectorItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.chime.model.VoiceConnectorItem.wrap(item)
          }.toList
        )
    override val createdTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val updatedTimestamp: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedTimestamp())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val voiceConnectorGroupArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorGroupArn())
        .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.VoiceConnectorGroup
  ): zio.aws.chime.model.VoiceConnectorGroup.ReadOnly = new Wrapper(impl)
}
