package zio.aws.chime.model
import java.lang.Integer
import zio.aws.chime.model.primitives.{
  VoiceConnectorItemPriority,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VoiceConnectorItem(
    voiceConnectorId: NonEmptyString,
    priority: VoiceConnectorItemPriority
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.VoiceConnectorItem = {
    import VoiceConnectorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.VoiceConnectorItem
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .priority(VoiceConnectorItemPriority.unwrap(priority): Integer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.VoiceConnectorItem.ReadOnly =
    zio.aws.chime.model.VoiceConnectorItem.wrap(buildAwsValue())
}
object VoiceConnectorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.VoiceConnectorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.VoiceConnectorItem =
      zio.aws.chime.model.VoiceConnectorItem(voiceConnectorId, priority)
    def voiceConnectorId: NonEmptyString
    def priority: VoiceConnectorItemPriority
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getPriority: ZIO[Any, Nothing, VoiceConnectorItemPriority] =
      ZIO.succeed(priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.VoiceConnectorItem
  ) extends zio.aws.chime.model.VoiceConnectorItem.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
    override val priority: VoiceConnectorItemPriority =
      zio.aws.chime.model.primitives.VoiceConnectorItemPriority(impl.priority())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.VoiceConnectorItem
  ): zio.aws.chime.model.VoiceConnectorItem.ReadOnly = new Wrapper(impl)
}
