package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VoiceConnectorSettings(
    cdrBucket: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.VoiceConnectorSettings = {
    import VoiceConnectorSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.VoiceConnectorSettings
      .builder()
      .optionallyWith(cdrBucket.map(value => value: java.lang.String))(
        _.cdrBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.VoiceConnectorSettings.ReadOnly =
    zio.aws.chime.model.VoiceConnectorSettings.wrap(buildAwsValue())
}
object VoiceConnectorSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.VoiceConnectorSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.VoiceConnectorSettings =
      zio.aws.chime.model.VoiceConnectorSettings(cdrBucket.map(value => value))
    def cdrBucket: Optional[String]
    def getCdrBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cdrBucket", cdrBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.VoiceConnectorSettings
  ) extends zio.aws.chime.model.VoiceConnectorSettings.ReadOnly {
    override val cdrBucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cdrBucket())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.VoiceConnectorSettings
  ): zio.aws.chime.model.VoiceConnectorSettings.ReadOnly = new Wrapper(impl)
}
