package zio.aws.chime
import zio.aws.chime.model.primitives.{
  EmailAddress,
  ChimeArn,
  ExternalUserIdType,
  GuidString,
  E164PhoneNumber,
  CallingRegion,
  Country,
  NonEmptyString,
  SensitiveString,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.chime.model.primitives.Metadata.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountName extends Subtype[String]
    type AccountName = zio.aws.chime.model.primitives.AccountName.Type
    object Alpha2CountryCode extends Subtype[String]
    type Alpha2CountryCode =
      zio.aws.chime.model.primitives.Alpha2CountryCode.Type
    object AreaCode extends Subtype[String]
    type AreaCode = zio.aws.chime.model.primitives.AreaCode.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.chime.model.primitives.Arn.Type
    object CallingName extends Subtype[String]
    type CallingName = zio.aws.chime.model.primitives.CallingName.Type
    object CallingRegion extends Subtype[String]
    type CallingRegion = zio.aws.chime.model.primitives.CallingRegion.Type
    object ChimeArn extends Subtype[String]
    type ChimeArn = zio.aws.chime.model.primitives.ChimeArn.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.chime.model.primitives.ClientRequestToken.Type
    object Content extends Subtype[String]
    type Content = zio.aws.chime.model.primitives.Content.Type
    object Country extends Subtype[String]
    type Country = zio.aws.chime.model.primitives.Country.Type
    object CpsLimit extends Subtype[Int]
    type CpsLimit = zio.aws.chime.model.primitives.CpsLimit.Type
    object DataRetentionInHours extends Subtype[Int]
    type DataRetentionInHours =
      zio.aws.chime.model.primitives.DataRetentionInHours.Type
    object E164PhoneNumber extends Subtype[String]
    type E164PhoneNumber = zio.aws.chime.model.primitives.E164PhoneNumber.Type
    object EmailAddress extends Subtype[String]
    type EmailAddress = zio.aws.chime.model.primitives.EmailAddress.Type
    object ExternalMeetingIdType extends Subtype[String]
    type ExternalMeetingIdType =
      zio.aws.chime.model.primitives.ExternalMeetingIdType.Type
    object ExternalUserIdType extends Subtype[String]
    type ExternalUserIdType =
      zio.aws.chime.model.primitives.ExternalUserIdType.Type
    object FunctionArn extends Subtype[String]
    type FunctionArn = zio.aws.chime.model.primitives.FunctionArn.Type
    object GuidString extends Subtype[String]
    type GuidString = zio.aws.chime.model.primitives.GuidString.Type
    type Integer = Int
    object Iso8601Timestamp extends Subtype[Instant]
    type Iso8601Timestamp = zio.aws.chime.model.primitives.Iso8601Timestamp.Type
    object JoinTokenString extends Subtype[String]
    type JoinTokenString = zio.aws.chime.model.primitives.JoinTokenString.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.chime.model.primitives.MaxResults.Type
    object MessageId extends Subtype[String]
    type MessageId = zio.aws.chime.model.primitives.MessageId.Type
    object Metadata extends Subtype[String]
    type Metadata = zio.aws.chime.model.primitives.Metadata.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.chime.model.primitives.NextToken.Type
    object NextTokenString extends Subtype[String]
    type NextTokenString = zio.aws.chime.model.primitives.NextTokenString.Type
    object NonEmptyContent extends Subtype[String]
    type NonEmptyContent = zio.aws.chime.model.primitives.NonEmptyContent.Type
    object NonEmptyResourceName extends Subtype[String]
    type NonEmptyResourceName =
      zio.aws.chime.model.primitives.NonEmptyResourceName.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString = zio.aws.chime.model.primitives.NonEmptyString.Type
    object NonEmptyString128 extends Subtype[String]
    type NonEmptyString128 =
      zio.aws.chime.model.primitives.NonEmptyString128.Type
    object NonNullableBoolean extends Subtype[Boolean]
    type NonNullableBoolean =
      zio.aws.chime.model.primitives.NonNullableBoolean.Type
    type NullableBoolean = Boolean
    object OriginationRoutePriority extends Subtype[Int]
    type OriginationRoutePriority =
      zio.aws.chime.model.primitives.OriginationRoutePriority.Type
    object OriginationRouteWeight extends Subtype[Int]
    type OriginationRouteWeight =
      zio.aws.chime.model.primitives.OriginationRouteWeight.Type
    object PhoneNumberMaxResults extends Subtype[Int]
    type PhoneNumberMaxResults =
      zio.aws.chime.model.primitives.PhoneNumberMaxResults.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.chime.model.primitives.Port.Type
    object PositiveInteger extends Subtype[Int]
    type PositiveInteger = zio.aws.chime.model.primitives.PositiveInteger.Type
    object ProfileServiceMaxResults extends Subtype[Int]
    type ProfileServiceMaxResults =
      zio.aws.chime.model.primitives.ProfileServiceMaxResults.Type
    object ProxySessionNameString extends Subtype[String]
    type ProxySessionNameString =
      zio.aws.chime.model.primitives.ProxySessionNameString.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.chime.model.primitives.ResourceName.Type
    object ResultMax extends Subtype[Int]
    type ResultMax = zio.aws.chime.model.primitives.ResultMax.Type
    object RetentionDays extends Subtype[Int]
    type RetentionDays = zio.aws.chime.model.primitives.RetentionDays.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString = zio.aws.chime.model.primitives.SensitiveString.Type
    object SipApplicationPriority extends Subtype[Int]
    type SipApplicationPriority =
      zio.aws.chime.model.primitives.SipApplicationPriority.Type
    object SipMediaApplicationName extends Subtype[String]
    type SipMediaApplicationName =
      zio.aws.chime.model.primitives.SipMediaApplicationName.Type
    object SipRuleName extends Subtype[String]
    type SipRuleName = zio.aws.chime.model.primitives.SipRuleName.Type
    object String128 extends Subtype[String]
    type String128 = zio.aws.chime.model.primitives.String128.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.chime.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.chime.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.chime.model.primitives.Timestamp.Type
    object TollFreePrefix extends Subtype[String]
    type TollFreePrefix = zio.aws.chime.model.primitives.TollFreePrefix.Type
    object TranscribeLanguageModelName extends Subtype[String]
    type TranscribeLanguageModelName =
      zio.aws.chime.model.primitives.TranscribeLanguageModelName.Type
    object TranscribePiiEntityTypes extends Subtype[String]
    type TranscribePiiEntityTypes =
      zio.aws.chime.model.primitives.TranscribePiiEntityTypes.Type
    object UriType extends Subtype[String]
    type UriType = zio.aws.chime.model.primitives.UriType.Type
    object UrlType extends Subtype[String]
    type UrlType = zio.aws.chime.model.primitives.UrlType.Type
    object UserId extends Subtype[String]
    type UserId = zio.aws.chime.model.primitives.UserId.Type
    object UserName extends Subtype[String]
    type UserName = zio.aws.chime.model.primitives.UserName.Type
    object VoiceConnectorGroupName extends Subtype[String]
    type VoiceConnectorGroupName =
      zio.aws.chime.model.primitives.VoiceConnectorGroupName.Type
    object VoiceConnectorItemPriority extends Subtype[Int]
    type VoiceConnectorItemPriority =
      zio.aws.chime.model.primitives.VoiceConnectorItemPriority.Type
    object VoiceConnectorName extends Subtype[String]
    type VoiceConnectorName =
      zio.aws.chime.model.primitives.VoiceConnectorName.Type
  }
  type AccountList = List[zio.aws.chime.model.Account]
  type AppInstanceAdminList = List[zio.aws.chime.model.AppInstanceAdminSummary]
  type AppInstanceList = List[zio.aws.chime.model.AppInstanceSummary]
  type AppInstanceStreamingConfigurationList =
    List[zio.aws.chime.model.AppInstanceStreamingConfiguration]
  type AppInstanceUserList = List[zio.aws.chime.model.AppInstanceUserSummary]
  type AttendeeIdList = List[GuidString]
  type AttendeeList = List[zio.aws.chime.model.Attendee]
  type AttendeeTagKeyList = List[TagKey]
  type AttendeeTagList = List[zio.aws.chime.model.Tag]
  type BatchCreateAttendeeErrorList =
    List[zio.aws.chime.model.CreateAttendeeError]
  type BatchCreateChannelMembershipErrors =
    List[zio.aws.chime.model.BatchCreateChannelMembershipError]
  type BotList = List[zio.aws.chime.model.Bot]
  type CallingRegionList = List[CallingRegion]
  type CapabilityList = List[zio.aws.chime.model.Capability]
  type ChannelBanSummaryList = List[zio.aws.chime.model.ChannelBanSummary]
  type ChannelMembershipForAppInstanceUserSummaryList =
    List[zio.aws.chime.model.ChannelMembershipForAppInstanceUserSummary]
  type ChannelMembershipSummaryList =
    List[zio.aws.chime.model.ChannelMembershipSummary]
  type ChannelMessageSummaryList =
    List[zio.aws.chime.model.ChannelMessageSummary]
  type ChannelModeratedByAppInstanceUserSummaryList =
    List[zio.aws.chime.model.ChannelModeratedByAppInstanceUserSummary]
  type ChannelModeratorSummaryList =
    List[zio.aws.chime.model.ChannelModeratorSummary]
  type ChannelSummaryList = List[zio.aws.chime.model.ChannelSummary]
  type CountryList = List[Country]
  type CreateAttendeeRequestItemList =
    List[zio.aws.chime.model.CreateAttendeeRequestItem]
  type CreateMeetingWithAttendeesRequestItemList =
    List[zio.aws.chime.model.CreateAttendeeRequestItem]
  type CredentialList = List[zio.aws.chime.model.Credential]
  type DNISEmergencyCallingConfigurationList =
    List[zio.aws.chime.model.DNISEmergencyCallingConfiguration]
  type E164PhoneNumberList = List[E164PhoneNumber]
  type ExternalUserIdList = List[ExternalUserIdType]
  type InviteList = List[zio.aws.chime.model.Invite]
  type LicenseList = List[zio.aws.chime.model.License]
  type MediaCapturePipelineList = List[zio.aws.chime.model.MediaCapturePipeline]
  type MeetingList = List[zio.aws.chime.model.Meeting]
  type MeetingTagKeyList = List[TagKey]
  type MeetingTagList = List[zio.aws.chime.model.Tag]
  type MemberArns = List[ChimeArn]
  type MemberErrorList = List[zio.aws.chime.model.MemberError]
  type Members = List[zio.aws.chime.model.Identity]
  type MembershipItemList = List[zio.aws.chime.model.MembershipItem]
  type NonEmptyStringList = List[String]
  type OrderedPhoneNumberList = List[zio.aws.chime.model.OrderedPhoneNumber]
  type OriginationRouteList = List[zio.aws.chime.model.OriginationRoute]
  type ParticipantPhoneNumberList = List[E164PhoneNumber]
  type Participants = List[zio.aws.chime.model.Participant]
  type PhoneNumberAssociationList =
    List[zio.aws.chime.model.PhoneNumberAssociation]
  type PhoneNumberCountriesList = List[zio.aws.chime.model.PhoneNumberCountry]
  type PhoneNumberErrorList = List[zio.aws.chime.model.PhoneNumberError]
  type PhoneNumberList = List[zio.aws.chime.model.PhoneNumber]
  type PhoneNumberOrderList = List[zio.aws.chime.model.PhoneNumberOrder]
  type PhoneNumberTypeList = List[zio.aws.chime.model.PhoneNumberType]
  type ProxySessions = List[zio.aws.chime.model.ProxySession]
  type RoomList = List[zio.aws.chime.model.Room]
  type RoomMembershipList = List[zio.aws.chime.model.RoomMembership]
  type SMAUpdateCallArgumentsMap = Map[SensitiveString, SensitiveString]
  type SensitiveStringList = List[SensitiveString]
  type SigninDelegateGroupList = List[zio.aws.chime.model.SigninDelegateGroup]
  type SipHeadersMap = Map[SensitiveString, SensitiveString]
  type SipMediaApplicationEndpointList =
    List[zio.aws.chime.model.SipMediaApplicationEndpoint]
  type SipMediaApplicationList = List[zio.aws.chime.model.SipMediaApplication]
  type SipRuleList = List[zio.aws.chime.model.SipRule]
  type SipRuleTargetApplicationList =
    List[zio.aws.chime.model.SipRuleTargetApplication]
  type StreamingNotificationTargetList =
    List[zio.aws.chime.model.StreamingNotificationTarget]
  type StringList = List[String]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.chime.model.Tag]
  type UpdatePhoneNumberRequestItemList =
    List[zio.aws.chime.model.UpdatePhoneNumberRequestItem]
  type UpdateUserRequestItemList =
    List[zio.aws.chime.model.UpdateUserRequestItem]
  type UserEmailList = List[EmailAddress]
  type UserErrorList = List[zio.aws.chime.model.UserError]
  type UserIdList = List[NonEmptyString]
  type UserList = List[zio.aws.chime.model.User]
  type VoiceConnectorGroupList = List[zio.aws.chime.model.VoiceConnectorGroup]
  type VoiceConnectorItemList = List[zio.aws.chime.model.VoiceConnectorItem]
  type VoiceConnectorList = List[zio.aws.chime.model.VoiceConnector]
}
