package zio.aws.cloudcontrol.model
import scala.jdk.CollectionConverters.*
sealed trait OperationStatus {
  def unwrap: software.amazon.awssdk.services.cloudcontrol.model.OperationStatus
}
object OperationStatus {
  def wrap(
      value: software.amazon.awssdk.services.cloudcontrol.model.OperationStatus
  ): zio.aws.cloudcontrol.model.OperationStatus = value match {
    case software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.CANCEL_IN_PROGRESS =>
      val r = CANCEL_IN_PROGRESS
      r
    case software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.CANCEL_COMPLETE =>
      val r = CANCEL_COMPLETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudcontrol.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.OperationStatus =
      software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.cloudcontrol.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.OperationStatus =
      software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.PENDING
  }
  case object IN_PROGRESS extends zio.aws.cloudcontrol.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.OperationStatus =
      software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.IN_PROGRESS
  }
  case object SUCCESS extends zio.aws.cloudcontrol.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.OperationStatus =
      software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.SUCCESS
  }
  case object FAILED extends zio.aws.cloudcontrol.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.OperationStatus =
      software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.FAILED
  }
  case object CANCEL_IN_PROGRESS
      extends zio.aws.cloudcontrol.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.OperationStatus =
      software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.CANCEL_IN_PROGRESS
  }
  case object CANCEL_COMPLETE
      extends zio.aws.cloudcontrol.model.OperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.cloudcontrol.model.OperationStatus =
      software.amazon.awssdk.services.cloudcontrol.model.OperationStatus.CANCEL_COMPLETE
  }
}
