package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait CachePolicyHeaderBehavior {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior
}
object CachePolicyHeaderBehavior {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior
  ): zio.aws.cloudfront.model.CachePolicyHeaderBehavior = value match {
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior.WHITELIST =>
      val r = whitelist
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.CachePolicyHeaderBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object none extends zio.aws.cloudfront.model.CachePolicyHeaderBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior.NONE
  }
  case object whitelist
      extends zio.aws.cloudfront.model.CachePolicyHeaderBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyHeaderBehavior.WHITELIST
  }
}
