package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CachePolicyQueryStringsConfig(
    queryStringBehavior: zio.aws.cloudfront.model.CachePolicyQueryStringBehavior,
    queryStrings: Optional[zio.aws.cloudfront.model.QueryStringNames] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringsConfig = {
    import CachePolicyQueryStringsConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringsConfig
      .builder()
      .queryStringBehavior(queryStringBehavior.unwrap)
      .optionallyWith(queryStrings.map(value => value.buildAwsValue()))(
        _.queryStrings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CachePolicyQueryStringsConfig.ReadOnly =
    zio.aws.cloudfront.model.CachePolicyQueryStringsConfig.wrap(buildAwsValue())
}
object CachePolicyQueryStringsConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringsConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CachePolicyQueryStringsConfig =
      zio.aws.cloudfront.model.CachePolicyQueryStringsConfig(
        queryStringBehavior,
        queryStrings.map(value => value.asEditable)
      )
    def queryStringBehavior
        : zio.aws.cloudfront.model.CachePolicyQueryStringBehavior
    def queryStrings
        : Optional[zio.aws.cloudfront.model.QueryStringNames.ReadOnly]
    def getQueryStringBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CachePolicyQueryStringBehavior
    ] = ZIO.succeed(queryStringBehavior)
    def getQueryStrings: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.QueryStringNames.ReadOnly
    ] = AwsError.unwrapOptionField("queryStrings", queryStrings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringsConfig
  ) extends zio.aws.cloudfront.model.CachePolicyQueryStringsConfig.ReadOnly {
    override val queryStringBehavior
        : zio.aws.cloudfront.model.CachePolicyQueryStringBehavior =
      zio.aws.cloudfront.model.CachePolicyQueryStringBehavior
        .wrap(impl.queryStringBehavior())
    override val queryStrings
        : Optional[zio.aws.cloudfront.model.QueryStringNames.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryStrings())
        .map(value => zio.aws.cloudfront.model.QueryStringNames.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CachePolicyQueryStringsConfig
  ): zio.aws.cloudfront.model.CachePolicyQueryStringsConfig.ReadOnly =
    new Wrapper(impl)
}
