package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudFrontOriginAccessIdentity(
    id: String,
    s3CanonicalUserId: String,
    cloudFrontOriginAccessIdentityConfig: Optional[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentity = {
    import CloudFrontOriginAccessIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentity
      .builder()
      .id(id: java.lang.String)
      .s3CanonicalUserId(s3CanonicalUserId: java.lang.String)
      .optionallyWith(
        cloudFrontOriginAccessIdentityConfig.map(value => value.buildAwsValue())
      )(_.cloudFrontOriginAccessIdentityConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly =
    zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity
      .wrap(buildAwsValue())
}
object CloudFrontOriginAccessIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity =
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity(
        id,
        s3CanonicalUserId,
        cloudFrontOriginAccessIdentityConfig.map(value => value.asEditable)
      )
    def id: String
    def s3CanonicalUserId: String
    def cloudFrontOriginAccessIdentityConfig: Optional[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getS3CanonicalUserId: ZIO[Any, Nothing, String] =
      ZIO.succeed(s3CanonicalUserId)
    def getCloudFrontOriginAccessIdentityConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudFrontOriginAccessIdentityConfig",
      cloudFrontOriginAccessIdentityConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentity
  ) extends zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly {
    override val id: String = impl.id(): String
    override val s3CanonicalUserId: String = impl.s3CanonicalUserId(): String
    override val cloudFrontOriginAccessIdentityConfig: Optional[
      zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudFrontOriginAccessIdentityConfig())
      .map(value =>
        zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentity
  ): zio.aws.cloudfront.model.CloudFrontOriginAccessIdentity.ReadOnly =
    new Wrapper(impl)
}
