package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloudFrontOriginAccessIdentityConfig(
    callerReference: String,
    comment: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig = {
    import CloudFrontOriginAccessIdentityConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig
      .builder()
      .callerReference(callerReference: java.lang.String)
      .comment(comment: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly =
    zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig
      .wrap(buildAwsValue())
}
object CloudFrontOriginAccessIdentityConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig =
      zio.aws.cloudfront.model
        .CloudFrontOriginAccessIdentityConfig(callerReference, comment)
    def callerReference: String
    def comment: String
    def getCallerReference: ZIO[Any, Nothing, String] =
      ZIO.succeed(callerReference)
    def getComment: ZIO[Any, Nothing, String] = ZIO.succeed(comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig
  ) extends zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly {
    override val callerReference: String = impl.callerReference(): String
    override val comment: String = impl.comment(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig
  ): zio.aws.cloudfront.model.CloudFrontOriginAccessIdentityConfig.ReadOnly =
    new Wrapper(impl)
}
