package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ContinuousDeploymentPolicy(
    id: String,
    lastModifiedTime: Timestamp,
    continuousDeploymentPolicyConfig: zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicy = {
    import ContinuousDeploymentPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicy
      .builder()
      .id(id: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .continuousDeploymentPolicyConfig(
        continuousDeploymentPolicyConfig.buildAwsValue()
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly =
    zio.aws.cloudfront.model.ContinuousDeploymentPolicy.wrap(buildAwsValue())
}
object ContinuousDeploymentPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ContinuousDeploymentPolicy =
      zio.aws.cloudfront.model.ContinuousDeploymentPolicy(
        id,
        lastModifiedTime,
        continuousDeploymentPolicyConfig.asEditable
      )
    def id: String
    def lastModifiedTime: Timestamp
    def continuousDeploymentPolicyConfig
        : zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getContinuousDeploymentPolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly
    ] = ZIO.succeed(continuousDeploymentPolicyConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicy
  ) extends zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly {
    override val id: String = impl.id(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val continuousDeploymentPolicyConfig
        : zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig
        .wrap(impl.continuousDeploymentPolicyConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicy
  ): zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly = new Wrapper(
    impl
  )
}
