package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ContinuousDeploymentPolicySummary(
    continuousDeploymentPolicy: zio.aws.cloudfront.model.ContinuousDeploymentPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicySummary = {
    import ContinuousDeploymentPolicySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicySummary
      .builder()
      .continuousDeploymentPolicy(continuousDeploymentPolicy.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ContinuousDeploymentPolicySummary.ReadOnly =
    zio.aws.cloudfront.model.ContinuousDeploymentPolicySummary
      .wrap(buildAwsValue())
}
object ContinuousDeploymentPolicySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ContinuousDeploymentPolicySummary =
      zio.aws.cloudfront.model.ContinuousDeploymentPolicySummary(
        continuousDeploymentPolicy.asEditable
      )
    def continuousDeploymentPolicy
        : zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly
    def getContinuousDeploymentPolicy: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly
    ] = ZIO.succeed(continuousDeploymentPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicySummary
  ) extends zio.aws.cloudfront.model.ContinuousDeploymentPolicySummary.ReadOnly {
    override val continuousDeploymentPolicy
        : zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly =
      zio.aws.cloudfront.model.ContinuousDeploymentPolicy
        .wrap(impl.continuousDeploymentPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicySummary
  ): zio.aws.cloudfront.model.ContinuousDeploymentPolicySummary.ReadOnly =
    new Wrapper(impl)
}
