package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait ContinuousDeploymentPolicyType {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType
}
object ContinuousDeploymentPolicyType {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType
  ): zio.aws.cloudfront.model.ContinuousDeploymentPolicyType = value match {
    case software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType.SINGLE_WEIGHT =>
      val r = SingleWeight
      r
    case software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType.SINGLE_HEADER =>
      val r = SingleHeader
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.ContinuousDeploymentPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType =
      software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object SingleWeight
      extends zio.aws.cloudfront.model.ContinuousDeploymentPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType =
      software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType.SINGLE_WEIGHT
  }
  case object SingleHeader
      extends zio.aws.cloudfront.model.ContinuousDeploymentPolicyType {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType =
      software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyType.SINGLE_HEADER
  }
}
