package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ContinuousDeploymentSingleHeaderConfig(
    header: String,
    value: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig = {
    import ContinuousDeploymentSingleHeaderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig
      .builder()
      .header(header: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ContinuousDeploymentSingleHeaderConfig.ReadOnly =
    zio.aws.cloudfront.model.ContinuousDeploymentSingleHeaderConfig
      .wrap(buildAwsValue())
}
object ContinuousDeploymentSingleHeaderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ContinuousDeploymentSingleHeaderConfig =
      zio.aws.cloudfront.model
        .ContinuousDeploymentSingleHeaderConfig(header, value)
    def header: String
    def value: String
    def getHeader: ZIO[Any, Nothing, String] = ZIO.succeed(header)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig
  ) extends zio.aws.cloudfront.model.ContinuousDeploymentSingleHeaderConfig.ReadOnly {
    override val header: String = impl.header(): String
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentSingleHeaderConfig
  ): zio.aws.cloudfront.model.ContinuousDeploymentSingleHeaderConfig.ReadOnly =
    new Wrapper(impl)
}
