package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyDistributionRequest(
    primaryDistributionId: String,
    staging: Optional[Boolean] = Optional.Absent,
    ifMatch: Optional[String] = Optional.Absent,
    callerReference: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CopyDistributionRequest = {
    import CopyDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CopyDistributionRequest
      .builder()
      .primaryDistributionId(primaryDistributionId: java.lang.String)
      .optionallyWith(staging.map(value => value: java.lang.Boolean))(_.staging)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .callerReference(callerReference: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CopyDistributionRequest.ReadOnly =
    zio.aws.cloudfront.model.CopyDistributionRequest.wrap(buildAwsValue())
}
object CopyDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CopyDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CopyDistributionRequest =
      zio.aws.cloudfront.model.CopyDistributionRequest(
        primaryDistributionId,
        staging.map(value => value),
        ifMatch.map(value => value),
        callerReference
      )
    def primaryDistributionId: String
    def staging: Optional[Boolean]
    def ifMatch: Optional[String]
    def callerReference: String
    def getPrimaryDistributionId: ZIO[Any, Nothing, String] =
      ZIO.succeed(primaryDistributionId)
    def getStaging: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("staging", staging)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
    def getCallerReference: ZIO[Any, Nothing, String] =
      ZIO.succeed(callerReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CopyDistributionRequest
  ) extends zio.aws.cloudfront.model.CopyDistributionRequest.ReadOnly {
    override val primaryDistributionId: String =
      impl.primaryDistributionId(): String
    override val staging: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.staging())
      .map(value => value: Boolean)
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
    override val callerReference: String = impl.callerReference(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CopyDistributionRequest
  ): zio.aws.cloudfront.model.CopyDistributionRequest.ReadOnly = new Wrapper(
    impl
  )
}
