package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCachePolicyResponse(
    cachePolicy: Optional[zio.aws.cloudfront.model.CachePolicy] =
      Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse = {
    import CreateCachePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse
      .builder()
      .optionallyWith(cachePolicy.map(value => value.buildAwsValue()))(
        _.cachePolicy
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateCachePolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateCachePolicyResponse.wrap(buildAwsValue())
}
object CreateCachePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateCachePolicyResponse =
      zio.aws.cloudfront.model.CreateCachePolicyResponse(
        cachePolicy.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def cachePolicy: Optional[zio.aws.cloudfront.model.CachePolicy.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getCachePolicy
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CachePolicy.ReadOnly] =
      AwsError.unwrapOptionField("cachePolicy", cachePolicy)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse
  ) extends zio.aws.cloudfront.model.CreateCachePolicyResponse.ReadOnly {
    override val cachePolicy
        : Optional[zio.aws.cloudfront.model.CachePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cachePolicy())
        .map(value => zio.aws.cloudfront.model.CachePolicy.wrap(value))
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse
  ): zio.aws.cloudfront.model.CreateCachePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
