package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDistributionResponse(
    distribution: Optional[zio.aws.cloudfront.model.Distribution] =
      Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse = {
    import CreateDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse
      .builder()
      .optionallyWith(distribution.map(value => value.buildAwsValue()))(
        _.distribution
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateDistributionResponse.wrap(buildAwsValue())
}
object CreateDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateDistributionResponse =
      zio.aws.cloudfront.model.CreateDistributionResponse(
        distribution.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def distribution: Optional[zio.aws.cloudfront.model.Distribution.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getDistribution
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Distribution.ReadOnly] =
      AwsError.unwrapOptionField("distribution", distribution)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse
  ) extends zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly {
    override val distribution
        : Optional[zio.aws.cloudfront.model.Distribution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distribution())
        .map(value => zio.aws.cloudfront.model.Distribution.wrap(value))
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse
  ): zio.aws.cloudfront.model.CreateDistributionResponse.ReadOnly = new Wrapper(
    impl
  )
}
