package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFunctionResponse(
    functionSummary: Optional[zio.aws.cloudfront.model.FunctionSummary] =
      Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse = {
    import CreateFunctionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse
      .builder()
      .optionallyWith(functionSummary.map(value => value.buildAwsValue()))(
        _.functionSummary
      )
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateFunctionResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateFunctionResponse.wrap(buildAwsValue())
}
object CreateFunctionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateFunctionResponse =
      zio.aws.cloudfront.model.CreateFunctionResponse(
        functionSummary.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def functionSummary
        : Optional[zio.aws.cloudfront.model.FunctionSummary.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getFunctionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FunctionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("functionSummary", functionSummary)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse
  ) extends zio.aws.cloudfront.model.CreateFunctionResponse.ReadOnly {
    override val functionSummary
        : Optional[zio.aws.cloudfront.model.FunctionSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functionSummary())
        .map(value => zio.aws.cloudfront.model.FunctionSummary.wrap(value))
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse
  ): zio.aws.cloudfront.model.CreateFunctionResponse.ReadOnly = new Wrapper(
    impl
  )
}
