package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateKeyGroupRequest(
    keyGroupConfig: zio.aws.cloudfront.model.KeyGroupConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest = {
    import CreateKeyGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest
      .builder()
      .keyGroupConfig(keyGroupConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateKeyGroupRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateKeyGroupRequest.wrap(buildAwsValue())
}
object CreateKeyGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateKeyGroupRequest =
      zio.aws.cloudfront.model.CreateKeyGroupRequest(keyGroupConfig.asEditable)
    def keyGroupConfig: zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly
    def getKeyGroupConfig
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly] =
      ZIO.succeed(keyGroupConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest
  ) extends zio.aws.cloudfront.model.CreateKeyGroupRequest.ReadOnly {
    override val keyGroupConfig
        : zio.aws.cloudfront.model.KeyGroupConfig.ReadOnly =
      zio.aws.cloudfront.model.KeyGroupConfig.wrap(impl.keyGroupConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest
  ): zio.aws.cloudfront.model.CreateKeyGroupRequest.ReadOnly = new Wrapper(impl)
}
