package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateOriginAccessControlRequest(
    originAccessControlConfig: zio.aws.cloudfront.model.OriginAccessControlConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlRequest = {
    import CreateOriginAccessControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlRequest
      .builder()
      .originAccessControlConfig(originAccessControlConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateOriginAccessControlRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateOriginAccessControlRequest
      .wrap(buildAwsValue())
}
object CreateOriginAccessControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateOriginAccessControlRequest =
      zio.aws.cloudfront.model
        .CreateOriginAccessControlRequest(originAccessControlConfig.asEditable)
    def originAccessControlConfig
        : zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly
    def getOriginAccessControlConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly
    ] = ZIO.succeed(originAccessControlConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlRequest
  ) extends zio.aws.cloudfront.model.CreateOriginAccessControlRequest.ReadOnly {
    override val originAccessControlConfig
        : zio.aws.cloudfront.model.OriginAccessControlConfig.ReadOnly =
      zio.aws.cloudfront.model.OriginAccessControlConfig
        .wrap(impl.originAccessControlConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlRequest
  ): zio.aws.cloudfront.model.CreateOriginAccessControlRequest.ReadOnly =
    new Wrapper(impl)
}
