package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateResponseHeadersPolicyResponse(
    responseHeadersPolicy: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicy
    ] = Optional.Absent,
    location: Optional[String] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyResponse = {
    import CreateResponseHeadersPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyResponse
      .builder()
      .optionallyWith(
        responseHeadersPolicy.map(value => value.buildAwsValue())
      )(_.responseHeadersPolicy)
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse
      .wrap(buildAwsValue())
}
object CreateResponseHeadersPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse =
      zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse(
        responseHeadersPolicy.map(value => value.asEditable),
        location.map(value => value),
        eTag.map(value => value)
      )
    def responseHeadersPolicy
        : Optional[zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly]
    def location: Optional[String]
    def eTag: Optional[String]
    def getResponseHeadersPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly
    ] =
      AwsError.unwrapOptionField("responseHeadersPolicy", responseHeadersPolicy)
    def getLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("location", location)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyResponse
  ) extends zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse.ReadOnly {
    override val responseHeadersPolicy
        : Optional[zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseHeadersPolicy())
        .map(value =>
          zio.aws.cloudfront.model.ResponseHeadersPolicy.wrap(value)
        )
    override val location: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => value: String)
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyResponse
  ): zio.aws.cloudfront.model.CreateResponseHeadersPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
