package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateStreamingDistributionRequest(
    streamingDistributionConfig: zio.aws.cloudfront.model.StreamingDistributionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest = {
    import CreateStreamingDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest
      .builder()
      .streamingDistributionConfig(streamingDistributionConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.CreateStreamingDistributionRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateStreamingDistributionRequest
      .wrap(buildAwsValue())
}
object CreateStreamingDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.CreateStreamingDistributionRequest =
      zio.aws.cloudfront.model.CreateStreamingDistributionRequest(
        streamingDistributionConfig.asEditable
      )
    def streamingDistributionConfig
        : zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly
    def getStreamingDistributionConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly
    ] = ZIO.succeed(streamingDistributionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest
  ) extends zio.aws.cloudfront.model.CreateStreamingDistributionRequest.ReadOnly {
    override val streamingDistributionConfig
        : zio.aws.cloudfront.model.StreamingDistributionConfig.ReadOnly =
      zio.aws.cloudfront.model.StreamingDistributionConfig
        .wrap(impl.streamingDistributionConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest
  ): zio.aws.cloudfront.model.CreateStreamingDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
