package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomErrorResponse(
    errorCode: Integer,
    responsePagePath: Optional[String] = Optional.Absent,
    responseCode: Optional[String] = Optional.Absent,
    errorCachingMinTTL: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse = {
    import CustomErrorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse
      .builder()
      .errorCode(errorCode: java.lang.Integer)
      .optionallyWith(responsePagePath.map(value => value: java.lang.String))(
        _.responsePagePath
      )
      .optionallyWith(responseCode.map(value => value: java.lang.String))(
        _.responseCode
      )
      .optionallyWith(errorCachingMinTTL.map(value => value: java.lang.Long))(
        _.errorCachingMinTTL
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CustomErrorResponse.ReadOnly =
    zio.aws.cloudfront.model.CustomErrorResponse.wrap(buildAwsValue())
}
object CustomErrorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CustomErrorResponse =
      zio.aws.cloudfront.model.CustomErrorResponse(
        errorCode,
        responsePagePath.map(value => value),
        responseCode.map(value => value),
        errorCachingMinTTL.map(value => value)
      )
    def errorCode: Integer
    def responsePagePath: Optional[String]
    def responseCode: Optional[String]
    def errorCachingMinTTL: Optional[Long]
    def getErrorCode: ZIO[Any, Nothing, Integer] = ZIO.succeed(errorCode)
    def getResponsePagePath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("responsePagePath", responsePagePath)
    def getResponseCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("responseCode", responseCode)
    def getErrorCachingMinTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("errorCachingMinTTL", errorCachingMinTTL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse
  ) extends zio.aws.cloudfront.model.CustomErrorResponse.ReadOnly {
    override val errorCode: Integer = impl.errorCode(): Integer
    override val responsePagePath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.responsePagePath())
      .map(value => value: String)
    override val responseCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.responseCode())
      .map(value => value: String)
    override val errorCachingMinTTL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCachingMinTTL())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CustomErrorResponse
  ): zio.aws.cloudfront.model.CustomErrorResponse.ReadOnly = new Wrapper(impl)
}
