package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomErrorResponses(
    quantity: Integer,
    items: Optional[Iterable[zio.aws.cloudfront.model.CustomErrorResponse]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses = {
    import CustomErrorResponses.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses
      .builder()
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly =
    zio.aws.cloudfront.model.CustomErrorResponses.wrap(buildAwsValue())
}
object CustomErrorResponses {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CustomErrorResponses =
      zio.aws.cloudfront.model.CustomErrorResponses(
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def quantity: Integer
    def items
        : Optional[List[zio.aws.cloudfront.model.CustomErrorResponse.ReadOnly]]
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.CustomErrorResponse.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses
  ) extends zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly {
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Optional[
      List[zio.aws.cloudfront.model.CustomErrorResponse.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudfront.model.CustomErrorResponse.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses
  ): zio.aws.cloudfront.model.CustomErrorResponses.ReadOnly = new Wrapper(impl)
}
