package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteRealtimeLogConfigRequest(
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest = {
    import DeleteRealtimeLogConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DeleteRealtimeLogConfigRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteRealtimeLogConfigRequest
      .wrap(buildAwsValue())
}
object DeleteRealtimeLogConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.DeleteRealtimeLogConfigRequest =
      zio.aws.cloudfront.model.DeleteRealtimeLogConfigRequest(
        name.map(value => value),
        arn.map(value => value)
      )
    def name: Optional[String]
    def arn: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest
  ) extends zio.aws.cloudfront.model.DeleteRealtimeLogConfigRequest.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest
  ): zio.aws.cloudfront.model.DeleteRealtimeLogConfigRequest.ReadOnly =
    new Wrapper(impl)
}
