package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FieldLevelEncryptionConfig(
    callerReference: String,
    comment: Optional[String] = Optional.Absent,
    queryArgProfileConfig: Optional[
      zio.aws.cloudfront.model.QueryArgProfileConfig
    ] = Optional.Absent,
    contentTypeProfileConfig: Optional[
      zio.aws.cloudfront.model.ContentTypeProfileConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfig = {
    import FieldLevelEncryptionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfig
      .builder()
      .callerReference(callerReference: java.lang.String)
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .optionallyWith(
        queryArgProfileConfig.map(value => value.buildAwsValue())
      )(_.queryArgProfileConfig)
      .optionallyWith(
        contentTypeProfileConfig.map(value => value.buildAwsValue())
      )(_.contentTypeProfileConfig)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly =
    zio.aws.cloudfront.model.FieldLevelEncryptionConfig.wrap(buildAwsValue())
}
object FieldLevelEncryptionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FieldLevelEncryptionConfig =
      zio.aws.cloudfront.model.FieldLevelEncryptionConfig(
        callerReference,
        comment.map(value => value),
        queryArgProfileConfig.map(value => value.asEditable),
        contentTypeProfileConfig.map(value => value.asEditable)
      )
    def callerReference: String
    def comment: Optional[String]
    def queryArgProfileConfig
        : Optional[zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly]
    def contentTypeProfileConfig
        : Optional[zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly]
    def getCallerReference: ZIO[Any, Nothing, String] =
      ZIO.succeed(callerReference)
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
    def getQueryArgProfileConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("queryArgProfileConfig", queryArgProfileConfig)
    def getContentTypeProfileConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "contentTypeProfileConfig",
      contentTypeProfileConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfig
  ) extends zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly {
    override val callerReference: String = impl.callerReference(): String
    override val comment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: String)
    override val queryArgProfileConfig
        : Optional[zio.aws.cloudfront.model.QueryArgProfileConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryArgProfileConfig())
        .map(value =>
          zio.aws.cloudfront.model.QueryArgProfileConfig.wrap(value)
        )
    override val contentTypeProfileConfig
        : Optional[zio.aws.cloudfront.model.ContentTypeProfileConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentTypeProfileConfig())
        .map(value =>
          zio.aws.cloudfront.model.ContentTypeProfileConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfig
  ): zio.aws.cloudfront.model.FieldLevelEncryptionConfig.ReadOnly = new Wrapper(
    impl
  )
}
