package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FieldLevelEncryptionProfile(
    id: String,
    lastModifiedTime: Timestamp,
    fieldLevelEncryptionProfileConfig: zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfile = {
    import FieldLevelEncryptionProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfile
      .builder()
      .id(id: java.lang.String)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .fieldLevelEncryptionProfileConfig(
        fieldLevelEncryptionProfileConfig.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly =
    zio.aws.cloudfront.model.FieldLevelEncryptionProfile.wrap(buildAwsValue())
}
object FieldLevelEncryptionProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FieldLevelEncryptionProfile =
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile(
        id,
        lastModifiedTime,
        fieldLevelEncryptionProfileConfig.asEditable
      )
    def id: String
    def lastModifiedTime: Timestamp
    def fieldLevelEncryptionProfileConfig
        : zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getFieldLevelEncryptionProfileConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly
    ] = ZIO.succeed(fieldLevelEncryptionProfileConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfile
  ) extends zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly {
    override val id: String = impl.id(): String
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
    override val fieldLevelEncryptionProfileConfig
        : zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly =
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig
        .wrap(impl.fieldLevelEncryptionProfileConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfile
  ): zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly =
    new Wrapper(impl)
}
