package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait Format {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.Format
}
object Format {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.Format
  ): zio.aws.cloudfront.model.Format = value match {
    case software.amazon.awssdk.services.cloudfront.model.Format.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.Format.URL_ENCODED =>
      val r = URLEncoded
      r
  }
  case object unknownToSdkVersion extends zio.aws.cloudfront.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.Format =
      software.amazon.awssdk.services.cloudfront.model.Format.UNKNOWN_TO_SDK_VERSION
  }
  case object URLEncoded extends zio.aws.cloudfront.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.Format =
      software.amazon.awssdk.services.cloudfront.model.Format.URL_ENCODED
  }
}
