package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait FrameOptionsList {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.FrameOptionsList
}
object FrameOptionsList {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.FrameOptionsList
  ): zio.aws.cloudfront.model.FrameOptionsList = value match {
    case software.amazon.awssdk.services.cloudfront.model.FrameOptionsList.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.FrameOptionsList.DENY =>
      val r = DENY
      r
    case software.amazon.awssdk.services.cloudfront.model.FrameOptionsList.SAMEORIGIN =>
      val r = SAMEORIGIN
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.FrameOptionsList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.FrameOptionsList =
      software.amazon.awssdk.services.cloudfront.model.FrameOptionsList.UNKNOWN_TO_SDK_VERSION
  }
  case object DENY extends zio.aws.cloudfront.model.FrameOptionsList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.FrameOptionsList =
      software.amazon.awssdk.services.cloudfront.model.FrameOptionsList.DENY
  }
  case object SAMEORIGIN extends zio.aws.cloudfront.model.FrameOptionsList {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.FrameOptionsList =
      software.amazon.awssdk.services.cloudfront.model.FrameOptionsList.SAMEORIGIN
  }
}
