package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GeoRestriction(
    restrictionType: zio.aws.cloudfront.model.GeoRestrictionType,
    quantity: Integer,
    items: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GeoRestriction = {
    import GeoRestriction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GeoRestriction
      .builder()
      .restrictionType(restrictionType.unwrap)
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GeoRestriction.ReadOnly =
    zio.aws.cloudfront.model.GeoRestriction.wrap(buildAwsValue())
}
object GeoRestriction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GeoRestriction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GeoRestriction =
      zio.aws.cloudfront.model
        .GeoRestriction(restrictionType, quantity, items.map(value => value))
    def restrictionType: zio.aws.cloudfront.model.GeoRestrictionType
    def quantity: Integer
    def items: Optional[List[String]]
    def getRestrictionType
        : ZIO[Any, Nothing, zio.aws.cloudfront.model.GeoRestrictionType] =
      ZIO.succeed(restrictionType)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GeoRestriction
  ) extends zio.aws.cloudfront.model.GeoRestriction.ReadOnly {
    override val restrictionType: zio.aws.cloudfront.model.GeoRestrictionType =
      zio.aws.cloudfront.model.GeoRestrictionType.wrap(impl.restrictionType())
    override val quantity: Integer = impl.quantity(): Integer
    override val items: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GeoRestriction
  ): zio.aws.cloudfront.model.GeoRestriction.ReadOnly = new Wrapper(impl)
}
