package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDistributionConfigResponse(
    distributionConfig: Optional[zio.aws.cloudfront.model.DistributionConfig] =
      Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse = {
    import GetDistributionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse
      .builder()
      .optionallyWith(distributionConfig.map(value => value.buildAwsValue()))(
        _.distributionConfig
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetDistributionConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetDistributionConfigResponse.wrap(buildAwsValue())
}
object GetDistributionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetDistributionConfigResponse =
      zio.aws.cloudfront.model.GetDistributionConfigResponse(
        distributionConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def distributionConfig
        : Optional[zio.aws.cloudfront.model.DistributionConfig.ReadOnly]
    def eTag: Optional[String]
    def getDistributionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.DistributionConfig.ReadOnly
    ] = AwsError.unwrapOptionField("distributionConfig", distributionConfig)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse
  ) extends zio.aws.cloudfront.model.GetDistributionConfigResponse.ReadOnly {
    override val distributionConfig
        : Optional[zio.aws.cloudfront.model.DistributionConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distributionConfig())
        .map(value => zio.aws.cloudfront.model.DistributionConfig.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse
  ): zio.aws.cloudfront.model.GetDistributionConfigResponse.ReadOnly =
    new Wrapper(impl)
}
