package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMonitoringSubscriptionRequest(distributionId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest = {
    import GetMonitoringSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest
      .builder()
      .distributionId(distributionId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetMonitoringSubscriptionRequest.ReadOnly =
    zio.aws.cloudfront.model.GetMonitoringSubscriptionRequest
      .wrap(buildAwsValue())
}
object GetMonitoringSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetMonitoringSubscriptionRequest =
      zio.aws.cloudfront.model.GetMonitoringSubscriptionRequest(distributionId)
    def distributionId: String
    def getDistributionId: ZIO[Any, Nothing, String] =
      ZIO.succeed(distributionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest
  ) extends zio.aws.cloudfront.model.GetMonitoringSubscriptionRequest.ReadOnly {
    override val distributionId: String = impl.distributionId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest
  ): zio.aws.cloudfront.model.GetMonitoringSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
