package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetMonitoringSubscriptionResponse(
    monitoringSubscription: Optional[
      zio.aws.cloudfront.model.MonitoringSubscription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse = {
    import GetMonitoringSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse
      .builder()
      .optionallyWith(
        monitoringSubscription.map(value => value.buildAwsValue())
      )(_.monitoringSubscription)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse.ReadOnly =
    zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse
      .wrap(buildAwsValue())
}
object GetMonitoringSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse =
      zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse(
        monitoringSubscription.map(value => value.asEditable)
      )
    def monitoringSubscription
        : Optional[zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly]
    def getMonitoringSubscription: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringSubscription",
      monitoringSubscription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse
  ) extends zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse.ReadOnly {
    override val monitoringSubscription
        : Optional[zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringSubscription())
        .map(value =>
          zio.aws.cloudfront.model.MonitoringSubscription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse
  ): zio.aws.cloudfront.model.GetMonitoringSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
