package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetOriginAccessControlResponse(
    originAccessControl: Optional[
      zio.aws.cloudfront.model.OriginAccessControl
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlResponse = {
    import GetOriginAccessControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlResponse
      .builder()
      .optionallyWith(originAccessControl.map(value => value.buildAwsValue()))(
        _.originAccessControl
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetOriginAccessControlResponse.ReadOnly =
    zio.aws.cloudfront.model.GetOriginAccessControlResponse
      .wrap(buildAwsValue())
}
object GetOriginAccessControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetOriginAccessControlResponse =
      zio.aws.cloudfront.model.GetOriginAccessControlResponse(
        originAccessControl.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def originAccessControl
        : Optional[zio.aws.cloudfront.model.OriginAccessControl.ReadOnly]
    def eTag: Optional[String]
    def getOriginAccessControl: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginAccessControl.ReadOnly
    ] = AwsError.unwrapOptionField("originAccessControl", originAccessControl)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlResponse
  ) extends zio.aws.cloudfront.model.GetOriginAccessControlResponse.ReadOnly {
    override val originAccessControl
        : Optional[zio.aws.cloudfront.model.OriginAccessControl.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originAccessControl())
        .map(value => zio.aws.cloudfront.model.OriginAccessControl.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlResponse
  ): zio.aws.cloudfront.model.GetOriginAccessControlResponse.ReadOnly =
    new Wrapper(impl)
}
