package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRealtimeLogConfigResponse(
    realtimeLogConfig: Optional[zio.aws.cloudfront.model.RealtimeLogConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse = {
    import GetRealtimeLogConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse
      .builder()
      .optionallyWith(realtimeLogConfig.map(value => value.buildAwsValue()))(
        _.realtimeLogConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetRealtimeLogConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetRealtimeLogConfigResponse.wrap(buildAwsValue())
}
object GetRealtimeLogConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetRealtimeLogConfigResponse =
      zio.aws.cloudfront.model.GetRealtimeLogConfigResponse(
        realtimeLogConfig.map(value => value.asEditable)
      )
    def realtimeLogConfig
        : Optional[zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly]
    def getRealtimeLogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("realtimeLogConfig", realtimeLogConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse
  ) extends zio.aws.cloudfront.model.GetRealtimeLogConfigResponse.ReadOnly {
    override val realtimeLogConfig
        : Optional[zio.aws.cloudfront.model.RealtimeLogConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.realtimeLogConfig())
        .map(value => zio.aws.cloudfront.model.RealtimeLogConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse
  ): zio.aws.cloudfront.model.GetRealtimeLogConfigResponse.ReadOnly =
    new Wrapper(impl)
}
