package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStreamingDistributionResponse(
    streamingDistribution: Optional[
      zio.aws.cloudfront.model.StreamingDistribution
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse = {
    import GetStreamingDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse
      .builder()
      .optionallyWith(
        streamingDistribution.map(value => value.buildAwsValue())
      )(_.streamingDistribution)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly =
    zio.aws.cloudfront.model.GetStreamingDistributionResponse
      .wrap(buildAwsValue())
}
object GetStreamingDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetStreamingDistributionResponse =
      zio.aws.cloudfront.model.GetStreamingDistributionResponse(
        streamingDistribution.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def streamingDistribution
        : Optional[zio.aws.cloudfront.model.StreamingDistribution.ReadOnly]
    def eTag: Optional[String]
    def getStreamingDistribution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.StreamingDistribution.ReadOnly
    ] =
      AwsError.unwrapOptionField("streamingDistribution", streamingDistribution)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse
  ) extends zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly {
    override val streamingDistribution
        : Optional[zio.aws.cloudfront.model.StreamingDistribution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamingDistribution())
        .map(value =>
          zio.aws.cloudfront.model.StreamingDistribution.wrap(value)
        )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse
  ): zio.aws.cloudfront.model.GetStreamingDistributionResponse.ReadOnly =
    new Wrapper(impl)
}
