package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait ItemSelection {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.ItemSelection
}
object ItemSelection {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.ItemSelection
  ): zio.aws.cloudfront.model.ItemSelection = value match {
    case software.amazon.awssdk.services.cloudfront.model.ItemSelection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.ItemSelection.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.cloudfront.model.ItemSelection.WHITELIST =>
      val r = whitelist
      r
    case software.amazon.awssdk.services.cloudfront.model.ItemSelection.ALL =>
      val r = all
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.ItemSelection {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ItemSelection =
      software.amazon.awssdk.services.cloudfront.model.ItemSelection.UNKNOWN_TO_SDK_VERSION
  }
  case object none extends zio.aws.cloudfront.model.ItemSelection {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ItemSelection =
      software.amazon.awssdk.services.cloudfront.model.ItemSelection.NONE
  }
  case object whitelist extends zio.aws.cloudfront.model.ItemSelection {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ItemSelection =
      software.amazon.awssdk.services.cloudfront.model.ItemSelection.WHITELIST
  }
  case object all extends zio.aws.cloudfront.model.ItemSelection {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.ItemSelection =
      software.amazon.awssdk.services.cloudfront.model.ItemSelection.ALL
  }
}
