package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.LambdaFunctionARN
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LambdaFunctionAssociation(
    lambdaFunctionARN: LambdaFunctionARN,
    eventType: zio.aws.cloudfront.model.EventType,
    includeBody: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociation = {
    import LambdaFunctionAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociation
      .builder()
      .lambdaFunctionARN(
        LambdaFunctionARN.unwrap(lambdaFunctionARN): java.lang.String
      )
      .eventType(eventType.unwrap)
      .optionallyWith(includeBody.map(value => value: java.lang.Boolean))(
        _.includeBody
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.LambdaFunctionAssociation.ReadOnly =
    zio.aws.cloudfront.model.LambdaFunctionAssociation.wrap(buildAwsValue())
}
object LambdaFunctionAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.LambdaFunctionAssociation =
      zio.aws.cloudfront.model.LambdaFunctionAssociation(
        lambdaFunctionARN,
        eventType,
        includeBody.map(value => value)
      )
    def lambdaFunctionARN: LambdaFunctionARN
    def eventType: zio.aws.cloudfront.model.EventType
    def includeBody: Optional[Boolean]
    def getLambdaFunctionARN: ZIO[Any, Nothing, LambdaFunctionARN] =
      ZIO.succeed(lambdaFunctionARN)
    def getEventType: ZIO[Any, Nothing, zio.aws.cloudfront.model.EventType] =
      ZIO.succeed(eventType)
    def getIncludeBody: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeBody", includeBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociation
  ) extends zio.aws.cloudfront.model.LambdaFunctionAssociation.ReadOnly {
    override val lambdaFunctionARN: LambdaFunctionARN =
      zio.aws.cloudfront.model.primitives
        .LambdaFunctionARN(impl.lambdaFunctionARN())
    override val eventType: zio.aws.cloudfront.model.EventType =
      zio.aws.cloudfront.model.EventType.wrap(impl.eventType())
    override val includeBody: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeBody())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.LambdaFunctionAssociation
  ): zio.aws.cloudfront.model.LambdaFunctionAssociation.ReadOnly = new Wrapper(
    impl
  )
}
