package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCachePoliciesRequest(
    `type`: Optional[zio.aws.cloudfront.model.CachePolicyType] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest = {
    import ListCachePoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListCachePoliciesRequest.ReadOnly =
    zio.aws.cloudfront.model.ListCachePoliciesRequest.wrap(buildAwsValue())
}
object ListCachePoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListCachePoliciesRequest =
      zio.aws.cloudfront.model.ListCachePoliciesRequest(
        `type`.map(value => value),
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def `type`: Optional[zio.aws.cloudfront.model.CachePolicyType]
    def marker: Optional[String]
    def maxItems: Optional[String]
    def getType: ZIO[Any, AwsError, zio.aws.cloudfront.model.CachePolicyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest
  ) extends zio.aws.cloudfront.model.ListCachePoliciesRequest.ReadOnly {
    override val `type`: Optional[zio.aws.cloudfront.model.CachePolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudfront.model.CachePolicyType.wrap(value))
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest
  ): zio.aws.cloudfront.model.ListCachePoliciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
