package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListContinuousDeploymentPoliciesResponse(
    continuousDeploymentPolicyList: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyList
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesResponse = {
    import ListContinuousDeploymentPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesResponse
      .builder()
      .optionallyWith(
        continuousDeploymentPolicyList.map(value => value.buildAwsValue())
      )(_.continuousDeploymentPolicyList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesResponse.ReadOnly =
    zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesResponse
      .wrap(buildAwsValue())
}
object ListContinuousDeploymentPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesResponse =
      zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesResponse(
        continuousDeploymentPolicyList.map(value => value.asEditable)
      )
    def continuousDeploymentPolicyList: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyList.ReadOnly
    ]
    def getContinuousDeploymentPolicyList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyList.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continuousDeploymentPolicyList",
      continuousDeploymentPolicyList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesResponse
  ) extends zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesResponse.ReadOnly {
    override val continuousDeploymentPolicyList: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyList.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.continuousDeploymentPolicyList())
      .map(value =>
        zio.aws.cloudfront.model.ContinuousDeploymentPolicyList.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesResponse
  ): zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
