package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionsByCachePolicyIdRequest(
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[String] = Optional.Absent,
    cachePolicyId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest = {
    import ListDistributionsByCachePolicyIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .cachePolicyId(cachePolicyId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdRequest
      .wrap(buildAwsValue())
}
object ListDistributionsByCachePolicyIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdRequest =
      zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        cachePolicyId
      )
    def marker: Optional[String]
    def maxItems: Optional[String]
    def cachePolicyId: String
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getCachePolicyId: ZIO[Any, Nothing, String] = ZIO.succeed(cachePolicyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest
  ) extends zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: String)
    override val cachePolicyId: String = impl.cachePolicyId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest
  ): zio.aws.cloudfront.model.ListDistributionsByCachePolicyIdRequest.ReadOnly =
    new Wrapper(impl)
}
