package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDistributionsByResponseHeadersPolicyIdRequest(
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[String] = Optional.Absent,
    responseHeadersPolicyId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest = {
    import ListDistributionsByResponseHeadersPolicyIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .responseHeadersPolicyId(responseHeadersPolicyId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest.ReadOnly =
    zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest
      .wrap(buildAwsValue())
}
object ListDistributionsByResponseHeadersPolicyIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest =
      zio.aws.cloudfront.model
        .ListDistributionsByResponseHeadersPolicyIdRequest(
          marker.map(value => value),
          maxItems.map(value => value),
          responseHeadersPolicyId
        )
    def marker: Optional[String]
    def maxItems: Optional[String]
    def responseHeadersPolicyId: String
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getResponseHeadersPolicyId: ZIO[Any, Nothing, String] =
      ZIO.succeed(responseHeadersPolicyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest
  ) extends zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: String)
    override val responseHeadersPolicyId: String =
      impl.responseHeadersPolicyId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest
  ): zio.aws.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest.ReadOnly =
    new Wrapper(impl)
}
