package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFieldLevelEncryptionProfilesRequest(
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest = {
    import ListFieldLevelEncryptionProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest.ReadOnly =
    zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
      .wrap(buildAwsValue())
}
object ListFieldLevelEncryptionProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest =
      zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest(
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def marker: Optional[String]
    def maxItems: Optional[String]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
  ) extends zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest
  ): zio.aws.cloudfront.model.ListFieldLevelEncryptionProfilesRequest.ReadOnly =
    new Wrapper(impl)
}
