package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKeyGroupsResponse(
    keyGroupList: Optional[zio.aws.cloudfront.model.KeyGroupList] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse = {
    import ListKeyGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse
      .builder()
      .optionallyWith(keyGroupList.map(value => value.buildAwsValue()))(
        _.keyGroupList
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly =
    zio.aws.cloudfront.model.ListKeyGroupsResponse.wrap(buildAwsValue())
}
object ListKeyGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListKeyGroupsResponse =
      zio.aws.cloudfront.model
        .ListKeyGroupsResponse(keyGroupList.map(value => value.asEditable))
    def keyGroupList: Optional[zio.aws.cloudfront.model.KeyGroupList.ReadOnly]
    def getKeyGroupList
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.KeyGroupList.ReadOnly] =
      AwsError.unwrapOptionField("keyGroupList", keyGroupList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse
  ) extends zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly {
    override val keyGroupList
        : Optional[zio.aws.cloudfront.model.KeyGroupList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyGroupList())
        .map(value => zio.aws.cloudfront.model.KeyGroupList.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse
  ): zio.aws.cloudfront.model.ListKeyGroupsResponse.ReadOnly = new Wrapper(impl)
}
