package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOriginRequestPoliciesResponse(
    originRequestPolicyList: Optional[
      zio.aws.cloudfront.model.OriginRequestPolicyList
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse = {
    import ListOriginRequestPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse
      .builder()
      .optionallyWith(
        originRequestPolicyList.map(value => value.buildAwsValue())
      )(_.originRequestPolicyList)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse.ReadOnly =
    zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse
      .wrap(buildAwsValue())
}
object ListOriginRequestPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse =
      zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse(
        originRequestPolicyList.map(value => value.asEditable)
      )
    def originRequestPolicyList
        : Optional[zio.aws.cloudfront.model.OriginRequestPolicyList.ReadOnly]
    def getOriginRequestPolicyList: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginRequestPolicyList.ReadOnly
    ] = AwsError.unwrapOptionField(
      "originRequestPolicyList",
      originRequestPolicyList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse
  ) extends zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse.ReadOnly {
    override val originRequestPolicyList
        : Optional[zio.aws.cloudfront.model.OriginRequestPolicyList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originRequestPolicyList())
        .map(value =>
          zio.aws.cloudfront.model.OriginRequestPolicyList.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse
  ): zio.aws.cloudfront.model.ListOriginRequestPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
