package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: zio.aws.cloudfront.model.Tags
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse
      .builder()
      .tags(tags.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.cloudfront.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListTagsForResourceResponse =
      zio.aws.cloudfront.model.ListTagsForResourceResponse(tags.asEditable)
    def tags: zio.aws.cloudfront.model.Tags.ReadOnly
    def getTags: ZIO[Any, Nothing, zio.aws.cloudfront.model.Tags.ReadOnly] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse
  ) extends zio.aws.cloudfront.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: zio.aws.cloudfront.model.Tags.ReadOnly =
      zio.aws.cloudfront.model.Tags.wrap(impl.tags())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse
  ): zio.aws.cloudfront.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
